/*********************************************/
/* Example Program for ET-ADuC847 STAMP V1.0 */
/* MCU      : ADuC847(XTAL = 32.768 KHz)     */
/*          : Frequency Bus = 12.582912 MHz  */
/* Compiler : Keil C51 (V7.50)               */
/* Function : ADC Unipolar Continuous Mode & */
/*          : Send Results to a USART        */
/* Write By : ETT CO.,LTD.(May/2011)         */
/*********************************************/

// Demo ADC Unipolar Mode
// 8 Channel ADC / 24 Bit
// ADC Input Scale 0-1.250 VDC
// ADC Input Mode = Unipolar -> AN?,ACOM(GND)
// ADC Reference = Internal 1.250 VDC

/* include  section */
#include <aduc847.h>						// ADUC847 SFR : File
#include <stdio.h>                			// Prototype declarations for I/O functions

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{   
  unsigned int val;		   					// ADC Result (HEX)
  float volt;								// ADC Result Volt
  
  PLLCON = 0x00;							// Initial Clock = 12.582912MHz

  /* Initial MCS51 Serial Port */
  /* Used Timer3 Gen. Baudrate */
  // Baud   = T3CON,T3FD
  // 9600   = 0x86,0x12
  // 19200  = 0x85,0x12
  // 38400  = 0x84,0x12
  // 57600  = 0x83,0x2D
  // 115200 = 0x82,0x2D
  // 230400 = 0x81,0x2D
  T3CON = 0x86;								// 9600BPS/12.58MHz(32.768KHz+PLL)
  T3FD  = 0x12;        
  SCON  = 0x50;  							// Serial Port Mode 1 (N,8,1)
  ES    = 0;     							// Disable Serial Interupt            
  TI    = 1;     							// Set TI to send First char of Keil-UART Function

  //Configure ADC and Start Converting...  
  /* Start of Initial ADC */
  ADC0CON1  =  0x00;						// Reset All Config Bit
  ADC0CON1 &= ~0xC0;						// Full Buffer
  ADC0CON1 |=  0x20;						// Unipolar Mode
  ADC0CON1 &= ~0x07;						// Reset ADC Input Range
  ADC0CON1 |=  0x07;						// Select ADC Input Range = 0V-2.56V(Unipolar) 

  ADC0CON2  =   0x00;						// Reset All Bit
  ADC0CON2 &=  ~0xC0;          				// Select Vref = Internal 1.25V
  ADC0CON2 &=  ~0x0F;	            		// ADC Input = AIN1,AINCOM
  ADCMODE   =   0x00;						// Reset All Bit
  ADCMODE  |=   0x40;						// Enable Automatic Reject 60Hz Noise	
  ADCMODE  |=   0x20;						// Enable ADC0  
  ADCMODE  |=   0x03;						// Continue Conversion

  //Chop Enable Filter
  ADCMODE  &=  ~0x08;						// Enable CHOP Mode  
  SF        =   0x0D;						// Fadc=105.3Hz,Tadc=9.52mS,Tsettle=19.04mS 

  //Chop Disable Filter
  //ADCMODE  |=   0x08;						// Disable CHOP Mode  
  //SF        =   0x52;						// Fadc=49.85Hz,Tadc=20.2mS,Tsettle=60.06mS  
  /* End of Initial ADC */

  /* Print Message to RS232 */
  printf("\n\n\n\n\r");
  printf("\n=======================================");
  printf("\nET-STAMP ADuC847.....From ETT CO.,LTD");  
  printf("\nDemo ADC Unipolar AN?,COM = 0..1.250V");    
  printf("\nDevice Offset = %bX%bX%bX",OF0H,OF0M,OF0L);   
  printf("\nDevice Gain   = %bX%bX%bX",GN0H,GN0M,GN0L);   
  printf("\n=======================================");
  
  //Zero Scale Calibrate  
  printf("\n\n\r");
  printf("\nDevice Calibrate Zero Scale Value");    
  printf("\nInput Zero Scale VDC to AN1 & COM");  
  printf("\nPress Any Key to Continue.......");    
  RI = 0;  
  while (!RI);								// Wait Any Key
  
  ADCMODE &=  ~0x07;	            		// Reset Mode ADC Input
  ADCMODE |=   0x04;	            		// ADC Input = Internal Zero Scale
  RDY0 =  0; 
  while(!RDY0);

  ADCMODE &=  ~0x07;	            		// Reset Mode ADC Input
  ADCMODE |=   0x06;	            		// ADC Input = System Zero Scale
  RDY0 =  0; 
  while(!RDY0);

  //Full Scale Calibrate
  printf("\n\n\r");
  printf("\nDevice Calibrate Full Scale Value");    
  printf("\nInput Full Scale VDC to AN1 & COM");
  printf("\nPress Any Key to Continue.......");  
  RI = 0;
  while (!RI);								// Wait Any Key
  
  ADCMODE &=  ~0x07;	            		// Reset Mode ADC Input
  ADCMODE |=   0x05;	            		// ADC Input = Internal Full Scale
  RDY0 =  0; 
  while(!RDY0);

  ADCMODE &=  ~0x07;	            		// Reset Mode ADC Input
  ADCMODE |=   0x07;	            		// ADC Input = System Full Scale
  RDY0 =  0; 
  while(!RDY0);
  
  printf("\n\r");
  printf("\n=======================================");
  printf("\nDevice Offset = %bX%bX%bX",OF0H,OF0M,OF0L);   
  printf("\nDevice Gain   = %bX%bX%bX",GN0H,GN0M,GN0L);   
  printf("\n=======================================");
  printf("\n\n\r");

  //Normal Operation
  ADCMODE  &=  ~0x07;	            		// Reset Mode ADC Input
  ADCMODE  |=   0x03;						// Continue Conversion  
  while (1) 
  {
    //Get Result in 16Bit ADC0H + ADC0M ,Ignore ADC0L
    //AN1
	ADC0CON2 &=  ~0x0F;	            		// ADC Input = AIN1,AINCOM
	RDY0 =  0; 
  	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf("\rAN[1..8] : %1.3f",volt); 		// Display 3-Digit Result(0-1.25V)	    	
	 	
	//AN2
	ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x01;	            		// ADC Input = AIN2,AINCOM
	RDY0 =  0; 
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	    	
	
	//AN3
    ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x02;	            		// ADC Input = AIN3,AINCOM
	RDY0 =  0; 
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	    	
	
	//AN4	
	ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x03;	            		// ADC Input = AIN4,AINCOM
	RDY0 =  0;
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	    	
	 
	//AN5	
	ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x04;	            		// ADC Input = AIN5,AINCOM
	RDY0 =  0; 
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	    	
	
	//AN6	
    ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x05;	            		// ADC Input = AIN6,AINCOM
    RDY0 =  0; 
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	    	
	
	//AN7
	ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x06;	            		// ADC Input = AIN7,AINCOM
	RDY0 =  0;
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	   
	 
	//AN8
    ADC0CON2 &=  ~0x0F;	            		// Reset Select ADC Input
	ADC0CON2 |=   0x07;	            		// ADC Input = AIN8,AINCOM
	RDY0 =  0; 
	while(!RDY0);	     					// Wait ADC Complete		
	val  = ((ADC0H<<8)&0xFF00);          	// Read MSB 8-Bits 
    val |= ((ADC0M<<0)&0x00FF);   			// Read LSB 8-Bits 
	volt = val * (1.250 / 65535.000);		// Volt = ADC Result x [1.250V / 65535]		
	printf(" : %1.3f",volt); 				// Display 3-Digit Result(0-1.25V)	    		
  }	    
}
